
#ifndef _KMNG_BASE_ERROR_H
#define _KMNG_BASE_ERROR_H
 
/*! \file error.h
    \brief This file containes all KMNG error codes.          
*/

#include "DX_VOS_BaseTypes.h"

#ifdef __cplusplus
extern "C"
{
#endif



/* success code */
#define KMNG_OK 										0

#define DX_SEP_KMNG_MODULE_ERROR_BASE			  0x0D000000

/* The error range number assigned to each module on its specified layer */
#define DX_KMNG_ERROR_MODULE_RANGE  0x00001000UL

#define KMNG_LAYER_ERROR_IDX  0UL
#define KMNG_LLF_LAYER_ERROR_IDX   1UL
/* KMNG module on the KMNG layer base address - 0x0D000000 */
#define DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE  (DX_SEP_KMNG_MODULE_ERROR_BASE + \
										(DX_KMNG_ERROR_MODULE_RANGE * KMNG_LAYER_ERROR_IDX ) )  

/* LLF module on the KMNG layer base address - 0x0D001000 */
#define DX_SEP_KMNG_LLF_MODULE_ERROR_BASE  (DX_SEP_KMNG_MODULE_ERROR_BASE + \
										(DX_KMNG_ERROR_MODULE_RANGE * KMNG_LLF_LAYER_ERROR_IDX ) )  


#ifdef  __cplusplus
}
#endif


#endif /* ifndef ERROR */





